#!/bin/bash

# remove existing file e.dat
rm -f e.dat

# scan values of the lattice constant from 10.00 to 10.45
for x in 10.00 10.05 10.10 10.15 10.20 10.25 10.30 \
         10.35 10.40 10.45
do
pw.x << EOF > si_scf.out
 &control
    calculation = 'scf'
    pseudo_dir = './',
    outdir='./',
 /
 &system
    ibrav=  2, celldm(1) = $x , nat=  2, ntyp= 1,
    ecutwfc = 8.0,
 /
 &electrons
    diagonalization='david'
    mixing_mode = 'plain'
    mixing_beta = 0.7
    conv_thr =  1.0d-8
 /
ATOMIC_SPECIES
 Si  28.086  Si.pz-vbc.UPF
ATOMIC_POSITIONS
 Si 0.00 0.00 0.00
 Si 0.25 0.25 0.25
K_POINTS
  10
   0.1250000  0.1250000  0.1250000   1.00
   0.1250000  0.1250000  0.3750000   3.00
   0.1250000  0.1250000  0.6250000   3.00
   0.1250000  0.1250000  0.8750000   3.00
   0.1250000  0.3750000  0.3750000   3.00
   0.1250000  0.3750000  0.6250000   6.00
   0.1250000  0.3750000  0.8750000   6.00
   0.1250000  0.6250000  0.6250000   3.00
   0.3750000  0.3750000  0.3750000   1.00
   0.3750000  0.3750000  0.6250000   3.00
EOF

# output the value of the lattice constant
echo -n $x >> e.dat " "
# extract the total energy from the output file, append to file e.dat
grep '^!' si_scf.out | awk '{print $5}'>> e.dat

done
