source commands.tcl

module PW -title "PWSCF GUI: module PW.x" -script {
    
    readfilter  ::pwscf::pwReadFilter
    writefilter ::pwscf::pwWriteFilter

    # ------------------------------------------------------------------------
    # devide the GUI on pages (each namelist on its own page)
    # ------------------------------------------------------------------------

    ########################################################################
    ##                                                                    ##
    ##                      &CONTROL NAMELIST                             ##
    ##                                                                    ##
    ########################################################################

    page controlPage -name "Control" {
        namelist control -name "CONTROL" {
            optional {
                #-default  "'PWSCF sample input'"
                var title -label "Job Title (title):" -validate string

                var calculation {
                    -label     "Type of calculation (calculation):"
                    -widget    radiobox
                    -textvalue {
                        "Self-Consistent-Field  <scf>"
                        "Non-selfconsistent calculation  <nscf>"
                        "Band structure calculation  <bands>"
                        "Ionic relaxation  <relax>"
                        "Ionic relaxation with Variable-Cell  <vc-relax>"
                        "Molecular dynamics  <md>"
                        "Molecular dynamics with Variable-Cell  <vc-md>"
                    }
                    -value {
                        'scf'
                        'nscf'
                        'bands'
                        'relax'
                        'vc-relax'
                        'md'
                        'vc-md'
                    }
                    -default "Self-Consistent-Field  <scf>"
                }
                
                var max_seconds {
                    -label    "Maximum CPU time \[in seconds\] (max_seconds):"
                    -validate posint
                }

                var restart_mode {
                    -label    "Restart mode (restart_mode):"
                    -widget   optionmenu
                    -textvalue {
                        "from scratch  <from_scratch>"
                        "from previous interrupted run  <restart>"
                    }
                    -value {
                        'from_scratch'
                        'restart'
                    }
                }

                var wf_collect {
                    -label     "OBSOLETE! Make a single restart file (wf_collect):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                separator -label "--- Directories/Files/Stdout ---"
                
                var outdir {
                    -label     "Temporary directory (outdir):"
                    -widget    entrydirselectquote
                    -validate  string
                }

                var wfcdir {
                    -label     "Temp. directory for files generated by each CPU (wfcdir):"
                    -widget    entrydirselectquote
                    -validate  string
                }

                var pseudo_dir \
                    -label    "Directory containing pseudopotential files (pseudo_dir:)" \
                    -widget   [list entrybutton "Directory ..." "::pwscf::pwSelectPseudoDir $this"] \
                    -validate  string

                var prefix -label "Prefix for I/O filenames (prefix):" -validate  string

                var lkpoint_dir {
                    -label "OBSOLETE! Store each k-point in its own subdirectory (lkpoint_dir):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var disk_io {
                    -label    "Disk Input/Output (disk_io):"
                    -textvalue {
                        high medium low nowf none
                    }
                    -value {
                        'high' 'medium' 'low' 'nowf' 'none'
                    }
                    -widget optionmenu
                }

                var verbosity {
                    -label     "Verbosity of output (verbosity):"
                    -widget    optionmenu
                    -textvalue {
                        high
                        low
                    }
                    -value {
                        'high'
                        'low'
                    }
                }

                var iprint {
                    -label   "Interval (in SCF iterations) for printing band energies (iprint):"
                    -widget   spinint
                    -validate nonnegint
                }

                separator -label "--- Ionic Minimization ---"

                #-text     "threshold on total energy for ionic minimization"
                var etot_conv_thr {
                    -label    "Convergence energy threshold \[in Ry\] (etot_conv_thr):"
                    -validate fortranposreal
                }

                #-text     "Convergence threshold on forces for ionic minimization"
                var forc_conv_thr {
                    -label    "Convergence force threshold \[in Ry/Bohr\] (forc_conv_thr):"
                    -validate fortranposreal
                }

                separator -label "--- Miscellaneous control parameters ---"
                
                var nstep {
                    -label    "Number of ionic steps (nstep):"
                    -widget   spinint
                    -validate posint
                }

                var tstress {
                    -label    "Calculate stress (tstress):"
                    -widget   radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var tprnfor {
                    -label     "Calculate forces (tprnfor):"
                    -variable  tprnfor
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }
                
                var dt {
                    -label     "Molecular-Dynamics time step (dt):"
                    -validate  fortranposreal
                }

                separator -label "--- Electric field options ---"
                
                var tefield {
                    -label     "Add a sawlike potential to bare ionic potential (tefield):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var dipfield {
                    -label     "Add a dipole correction to bare ionic potential (dipfield):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var lelfield {
                    -label     "Add a homogeneous finite electric field (lelfield):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }
                
                var nberrycyc {
                    -label "Num. of iterations for lelfield [see help] (nberrycyc):"
                    -validate posint
                }

                separator -label "--- Miscellaneous options ---"
                
                var lorbm {
                    -label     "Perform orbital magnetization calculation (lorbm):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var lfcp {
                    -label "Perform a constant bias potential calculation with ESM method (lfcp):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var twochem {
                    -label "Perform a two chemical-potential calculation (twochem):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }

                var gate {
                    -label "Perform charged cell calculation using counter charged plate (gate):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var trism {
                    -label "Perform a 3D-RISM-SCF calculation (trism):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }

                separator -label "--- Berry phase ---"

                var lberry {
                    -label     "Calculate Berry phase (lberry):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }
                var gdir   {
                    -label    "Direction of the k-point strings (gdir):"
                    -widget   optionmenu
                    -textvalue {
                        "along 1st reciprocal vector"
                        "along 2nd reciprocal vector"
                        "along 3rd reciprocal vector"
                    }
                    -value { 1 2 3 }            
                }
                var nppstr {
                    -label "Num. of k-points along each symmetry-reduced string (nppstr):"
                    -validate posint
                }
            }            
        }
    }
    

    ########################################################################
    ##                                                                    ##
    ##                      &SYSTEM NAMELIST                              ##
    ##                                                                    ##
    ########################################################################

    page systemPage -name "System" {

        # ----------------------------------------------------
        # REQUIRED variables
        # ----------------------------------------------------

        namelist system -name "SYSTEM" {            
            required {
                #
                # WARNING: if you change the strings among the possible
                #          ibrav values, then search the "tracevar ibrav"
                #          section in the file pwscf-special.tcl and change
                #          there the strings to match EXACTLY with the 
                #          ones defined here !!!
                #           
                var ibrav {
                    -label     "Braivas lattice index (ibrav):"
                    -fmt       %d
                    -widget    combobox
                    -textvalue {
                        "Free lattice"
                        "Cubic P (sc)"
                        "Cubic F (fcc)"
                        "Cubic I (bcc)"
                        "Cubic I, more symmetric axis (bcc)"
                        "Hexagonal and Trigonal P"
                        "Trigonal R, 3fold axis c"
                        "Trigonal R, 3fold axis <111>"
                        "Tetragonal P (st)"
                        "Tetragonal I (bct)"
                        "Orthorhombic P"
                        "Orthorhombic base-centered (bco)"
                        "Orthorhombic base-centered, alternate (bco)"
                        "Orthorhombic one-face base-centered A-type"
                        "Orthorhombic face-centered"
                        "Orthorhombic body-centered"
                        "Monoclinic P, unique axis c"
                        "Monoclinic P, unique axis b"
                        "Monoclinic base-centered"
                        "Monoclinic base-centered, unique axis b"
                        "Triclinic P"
                    }
                    -value {
                        0 1 2 3 -3
                        4 5 -5
                        6 7 8 9 -9 91
                        10 11 12 -12
                        13 -13 14
                    }
                }

                group lattice_spec -name "Lattice specification:" -decor normal {
                    auxilvar how_lattice {
                        -label     "How to specify lattice:"
                        -value     {celldm abc}
                        -textvalue {"by celldm()" "by A,B,C,cosAB,cosAC,cosBC"}
                        -widget    radiobox
                    }
                    
                    dimension celldm {
                        -label "Crystallographic constants (celldm)"
                        -validate  fortranreal
                        -start 1
                        -end   6
                    }
                    
                    group abc {
                        packwidgets left
                        var A -label "A:" -validate fortranposreal
                        var B -label "B:" -validate fortranposreal
                        var C -label "C:" -validate fortranposreal
                    }
                    group cosABC {
                        packwidgets left
                        var cosAB -label "cosAB:" -validate fortranreal             
                        var cosAC -label "cosAC:" -validate fortranreal
                        var cosBC -label "cosBC:" -validate fortranreal             
                    }
                }

                var nat {
                    -label    "Number of atoms in the unit cell (nat):"
                    -fmt       %d
                    -default   1
                    -widget    spinint
                    -validate  posint
                }
                
                var ntyp {
                    -label    "Number of types of atoms in the unit cell (ntyp):"
                    -fmt      %d
                    -default  1
                    -widget   spinint  
                    -validate posint
                }               
                
                var ecutwfc {
                    -label    "Kinetic energy cutoff for WAVEFUNCTION \[in Ry\] (ecutwfc):"
                    -validate fortranposreal
                }

                var ecutrho {
                    -label    "Kinetic energy cutoff for DENSITY \[in Ry\] (ecutrho):"
                    -validate fortranposreal
                }
            }

            # ----------------------------------------------------
            # OPTIONAL variables
            # ----------------------------------------------------

            optional {          
                var nbnd {
                    -label    "Number of electronic states (nbnd):"
                    -widget   spinint
                    -validate posint
                    -fmt      %d
                }

                var tot_charge {
                    -label    "Total system charge (tot_charge):"
                    -validate fortranreal
                    -fmt      %f
                }

                dimension starting_charge {
                    -label "Starting charge (starting_charge):"
                    -text  "Starting charge for atomic species"
                    -validate  fortranreal
                    -start 1 -end 1
                }
                
                var input_dft -label    "Exchange-correlation functional (input_dft):"

                separator -label "--- Symmetry ---"

                group symmetry_group -decor normal {
                    var nosym {
                        -label     "Do not use the symmetry (nosym):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                    
                    var nosym_evc {
                        -label     "Do not use the symmetry except for the k-points (nosym_evc):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                    
                    var noinv { 
                        -label     "Disable time reversal symmetry in k-point generation (noinv):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }

                    var no_t_rev { 
                        -label     "Disable the symmetry operations that require time reversal (no_t_rev):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }

                    var force_symmorphic { 
                        -label     "Force the symmetry group to be symmorphic (force_symmorphic):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }

                    var use_all_frac { 
                        -label     "Use all symmetry operations with fractionary translations (use_all_frac):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                }

                separator -label "--- Occupations ---"

                var occupations {
                    -label    "Occupation of states (occupations):"
                    -widget   optionmenu
                    -textvalue {
                        smearing tetrahedra tetrahedra_lin tetrahedra_opt fixed "read from input"
                    }
                    -value {
                        'smearing' 'tetrahedra' 'tetrahedra_lin' 'tetrahedra_opt' 'fixed' 'from_input'
                    }
                }

                var one_atom_occupations {
                    -text  "For isolated atoms only (nat=1)"
                    -label "Order the wavefunctions as the atomic starting wavefunctions (one_atom_occupations):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var starting_spin_angle {
                    -text  "For spin-orbit case when domag=.TRUE."
                    -label "Multiply the initial radial wavefunctions by spin-angle functions (starting_spin_angle):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }

                var degauss {
                    -label    "Gaussian spreading for BZ integration \[in Ry\] (degauss):"
                    -validate fortrannonnegreal
                }

                var smearing {
                    -label    "Type of spreading/smearing (smearing):"
                    -textvalue {
                        "ordinary Gaussian spreading  <gaussian>"
                        "first order interpolation in Methfessel-Paxton spreading  <methfessel-paxton>"
                        "Marzari-Vanderbilt cold smearing  <marzari-vanderbilt>"
                        "Fermi-Dirac smearing  <fermi-dirac>"
                    }
                    -value  {
                        'gaussian'
                        'methfessel-paxton'
                        'marzari-vanderbilt'
                        'fermi-dirac'
                    }
                    -widget optionmenu
                }

                separator -label "--- Spin polarization ---"

                group spinpol_group -decor normal {
                    var nspin {
                        -label     "Perform spin-polarized calculation (nspin):"
                        -textvalue {No Yes}
                        -value     {1  2}
                        -widget    radiobox
                    }
                    
                    group spin_polarization -decor none {
                    
                        dimension starting_magnetization {
                            -label "Starting magnetization (starting_magnetization):"
                            -text  "Specify starting magnetization (between -1 and 1) for each \"magnetic\" species"
                            -validate  fortranreal
                            -start 1 -end 1
                        }
                        
                        var tot_magnetization {
                            -label     "Total magnetization (N el. up-down) (tot_magnetization):"
                            -validate  posint
                            -widget    spinint
                        }
                    }           
                }

                separator -label "--- Noncolinear calculation ---"

                group noncolin_topgroup -decor normal {
                    
                    var noncolin {
                        -label     "Perform noncolinear calculation (noncolin):"
                        -textvalue {No Yes}
                        -value     {.false. .true.}
                        -widget    radiobox
                    }           

                    group noncolin_group {
                        dimension angle1 {
                            -label "Starting magnetization direction (angle1) :"
                            -text  "Specify starting magnetization direction for each \"magnetic\" species"
                            -validate  fortranreal
                            -start 1 -end 1
                        }
                        
                        dimension angle2 {
                            -label "Starting magnetization direction (angle2):"
                            -text  "Specify starting magnetization direction for each \"magnetic\" species"
                            -validate  fortranreal
                            -start 1 -end 1
                        }

                        var lforcet {
                            -label "Use existing collinear density read from file (lforcet):"
                            -widget    radiobox
                            -textvalue { Yes No }              
                            -value     { .true. .false. }
                        }
                        
                        var lspinorb {
                            -label     "Allow the use of a pseudopotential with spin-orbit (lspinorb):"
                            -textvalue {No Yes}
                            -value     {.false.  .true.}
                            -widget    radiobox
                        }
                    }
                }

                separator -label "--- Constrained/Fixed magnetization ---"

                group constrained_magnetization_group -decor normal {
                    
                    var constrained_magnetization {
                        -label     "Constrained magnetic calculation (constrained_magnetization):"
                        -textvalue {
                            "no constraint  <none>" 
                            "constrain TOTAL magnetization  <total>"
                            "constrain ATOMIC magnetization  <atomic>"
                            "constrain the direction of total magnetization  <total directioin>"
                            "constrain magnetization to \"ATOMIC DIRECTION\"  <atomic direction>"
                        }
                        -value     {'none' 'total' 'atomic' {'total direction'} {'atomic direction'}}
                        -widget    optionmenu
                    }
                    
                    dimension fixed_magnetization {
                        -label "Fixed total magnetization"
                        -start 1 -end 3
                        -validate fortranreal
                    }
                    
                    #               dimension B_field {
                    #                   -label "Add a fixed magnetic field (B_field):"
                    #                   -start 1 -end 3
                    #                   -validate fortranreal
                    #               }
                    
                    var lambda {
                        -label "Lamda parameter for constrained magnetization (lambda):"
                        -validate fortranreal
                    }
                    
                    var report {
                        -label "Interval (in iterations) for printing atomic magnetic moments (report):"
                        -validate posint
                    }
                }

                separator -label "--- Hartree Fock & Hybrid Functionals ---"

                group HF_group -decor normal {
                    var ecutfock {
                        -label    "Kinetic energy cutoff for exact exchange operator \[in Ry\] (ecutfock):"
                        -validate fortranposreal
                    }

                    var ace {
                        -label "Use Adaptively Compressed Exchange (ace):"
                        -widget    radiobox
                        -textvalue { Yes No }	      
                        -value     { .true. .false. }
                    }

                    var exx_fraction {
                        -label "Fraction of EXX for hybrid functional calculations (exx_fraction):"
                        -validate fortranreal
                    }
                    
                    var exxdiv_treatment {
                        -label "Approach for treating Coulomb potential divergencies at small q vectors (exxdiv_treatment):"
                        -widget optionmenu
                        -value {
                            'gygi-baldereschi'
                            'vcut_spherical'
                            'vcut_ws'
                            'none'
                        }
                        -textvalue {
                            gygi-baldereschi
                            vcut_spherical
                            vcut_ws
                            none
                        }
                    }

                    var x_gamma_extrapolation {
                        -label "Extrapolate the G=0 term of the potential for EXX (x_gamma_extrapolation):"
                        -textvalue {No Yes}
                        -value     {.false.  .true.}
                        -widget    radiobox
                    }
                    var ecutvcut {
                        -label "Reciprocal space cutoff for exxdiv_treatment (ecutvcut):"
                        -validate fortranreal
                    }
                    
                    var screening_parameter {
                        -label "Screening_parameter for HSE like hybrid functionals (screening_parameter):"
                        -validate fortranreal
                    }

                    var localization_thr {
                        -label "Exchange localization overlap threshold (localization_thr)"
                        -validate fortranreal
                    }

                    group nqx123 {                  
                        packwidgets left
                        var nqx1 -label "nqx1:" -validate fortranposreal
                        var nqx2 -label "nqx2:" -validate fortranposreal
                        var nqx3 -label "n1x3:" -validate fortranposreal                    
                    }
                }
                
                separator -label "--- Hubbard parameters ---"

                group hubbard -decor normal {
                    table Hubbard_occ {
                        -caption "Hubbard occupations (Hubbard_occ):"
                        -head {{1st manifold} {2nd manifold} {3rd manifold}}
                        -validate fortranreal
                        -cols 3
                        -rows 1
                    }

                    dimension Hubbard_alpha {
                        -label     "Hubbard alpha (Hubbard_alpha):"
                        -validate  fortranreal
                        -start 1 -end 1
                    }
                        
                    dimension Hubbard_beta {
                        -label     "Hubbard beta (Hubbard_beta):"
                        -validate  fortranreal
                        -start 1 -end 1
                    }

                    # cannot handel 3D multidimension: starting_ns_eigenvalue(m,ispin,ityp)
                }    

                separator -label "--- DMFT ---"
                
                var dmft {
                    -label "DMFT (dmft):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }
                
                var dmft_prefix {
                    -label "DMFT prefix to hdf5 archive (dmft_prefix):"
                    -validate string
                }
                
                var ensemble_energies {
                    -label "Calculate ensemble of xc energies (ensemble_energies):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }

                separator -label "--- Variable cell parameters ---"

                group vc_md -decor normal {                 
                    var ecfixed {
                        -label     "ecfixed:"
                        -validate  fortranreal
                    }
                    var qcutz {
                        -label     "qcutz:"
                        -validate  fortranreal
                    }
                    var q2sigma {
                        -label     "q2sigma:"
                        -validate  fortranreal
                    }
                }       
                
                separator -label "--- Saw-like potential parameters ---"

                group tefield_group -decor normal {
                    var edir {
                        -label    "Direction of electric field (edir)"
                        -widget   optionmenu
                        -textvalue {
                            "along 1st reciprocal vector"
                            "along 2nd reciprocal vector"
                            "along 3rd reciprocal vector"
                        }
                        -value { 1 2 3 }
                    }
                    
                    var emaxpos {
                        -text     "Position of maximum of sawlike potential within the unit cell"
                        -label    "Position of maximum (emaxpos):"
                        -validate fortranreal
                    }

                    var eopreg {
                        -text     "Part of the unit cell where the sawlike potential decreases"
                        -label    "Where the sawlike potential decreases (eopreg):"
                        -validate fortranreal
                    }

                    var eamp -label "Amplitude of the electric field \[in a.u.\] (eamp):"
                }

                separator -label "--- Low-dimensional calculation ---"

                var assume_isolated {
                    -label "Type of correction for isolated systems (assume_isolated):"
                    -widget    radiobox
                    -textvalue {
                        "Makov-Payne <makov-payne>"
                        "Martyna-Tuckerman <martyna-tuckerman>"
                        "Effective Screening Medium <esm>"
                        "2D <2D>"
                        "No correction <none>"
                    }
                    -value {'makov-payne' 'martyna-tuckerman' 'esm' '2D' 'none'}
                }       

                separator -label "--- Effective screening medium ---"
                
                group ESM -decor normal {
                    var esm_bc {
                        -label "Boundary conditions for ESM (esm_bc):"
                        -widget    radiobox
                        -textvalue {
                            "vacuum-slab-vacuum (open boundary conditions) <bc1>"
                            "metal-slab-metal (dual electrode configuration) <bc2>"
                            "vacuum-slab-metal <bc3>"
                            "regular periodic calculation (no ESM) <pbc>"
                        }
                        -value {'bc1' 'bc2' 'bc3' 'pbc'}
                    }   
                    var esm_w {
                        -label    "Position offset [in a.u.] of the start of the ESM region (esm_w):"
                        -validate fortranreal
                    }
                    var esm_efield {
                        -label    "Magnitude of the applied electric field [Ryd/a.u.] (esm_efield):"
                        -validate fortranreal
                    }
                    var esm_nfit {
                        -label    "Number of z-grid points for the polynomial fit @ cell edge (esm_nfit):"
                        -validate posint
                    }
                }
                separator -label "--- Constant-mu calculation with grand-canonical SCF ---"

                var lgcscf {
                    -label "Perform a constant-mu calculation with grand-canonical SCF (lgcscf):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }

                group gcscf_group -name "Grand-canonical SCF (GC-SCF) specs" -decor normal {
                    var gcscf_mu {
                        -label "The target Fermi energy (in eV) of GC-SCF (gcscf_mu):"
                        -validate fortranreal
                    }
                    
                    var gcscf_conv_thr {
                        -label "Convergence threshold of Fermi energy (in eV) for GC-SCF (gcscf_conv_thr):"
                        -validate fortranreal
                    }
                    
                    var gcscf_beta {
                        -label "Mixing factor for GC-SCF (gcscf_beta):"
                        -validate fortranreal
                    }
                }

                separator -label "--- Semi-empirical van der Waals (aka DFT-D) ---"

                group vdW -decor normal {

                    var vdw_corr {
                        -label "Type of Van der Waals correction (vdw_corr):"
                        -textvalue {Grimme-D2  Grimme-D3  Tkatchenko-Scheffler "Many-Body-Dispersion (MBD) vdW" XDM  None}
                        -value     {'grimme-d2' 'grimme-d3' 'TS' 'MBD' 'XDM' ''}
                        -widget    optionmenu
                    }  

                    group dftdG {
                        var london_s6 -label "Global scaling parameter for DFT-D (london_s6):" -validate fortranposreal
                        var london_rcut -label "Cutoff radius for dispersion interactions \[in a.u.\] (london_rcut):" -validate fortranposreal
                        dimension london_c6 -label "Atomic C6 coefficient for DFT-D (london_c6):" -start 1 -end 1 -validate fortranposreal
                        dimension london_rvdw -label "Atomic vdW radius for DFT-D (london_rvdw):" -start 1 -end 1 -validate fortranposreal                      
                    }

                    group dftd3G {
                        var dftd3_version {
                            -label "Version of Grimme DFT-D3 (dftd3_version):"
                            -widget optionmenu
                            -textvalue {
                                "Grimme-D3 (zero damping)"
                                "Grimme-D3 (BJ damping)"
                                "Grimme-D3M (zero damping)"
                                "Grimme-D3M (BJ damping)"
                                "original Grimme-D2 parametrization"
                            }
                            -value {
                                3
                                4
                                5
                                6
                                2
                            }
                        }

                        var dftd3_threebody {
                            -label "Use three-body terms in Grimme-D3 (dftd3_threebody):"
                            -widget    radiobox
                            -textvalue { Yes No }              
                            -value     { .true. .false. }
                        }
                    }
                    
                    group tsG {
                        var ts_vdw_econv_thr {
                            -label "Convergence threshold of the vdW energy (ts_vdw_econv_thr):"
                            -validate fortranreal
                        }

                        var ts_vdw_isolated {
                            -label "Compute the Tkatchenko-Scheffler vdW energy for an isolated system (ts_vdw_isolated):"
                            -widget    radiobox
                            -textvalue { Yes No }             
                            -value     { .true. .false. }
                        }
                    }
                    
                    group xdmG {
                        var xdm_a1 -label "Damping function parameter a1 (xdm_a1):" -validate fortranreal
                        var xdm_a2 -label "Damping function parameter a1 (xdm_a2):" -validate fortranreal
                    }
                    
                    group vdw_obsolete -name "Obsolete vdW variables:" -decor normal {
                        
                        var london {
                            -label "Compute the semi-empirical dispersion term \[aka DFT-D\] (london):"
                            -textvalue {Yes No}
                            -value     {.true. .false.}
                            -widget    radiobox
                        }  
                        
                        var xdm {
                            -label "Compute the XDM-type dispersion term (xdm):"
                            -textvalue {Yes No}
                            -value     {.true. .false.}
                            -widget    radiobox
                        }  
                    }
                }

                separator -label "--- Space group: crystal type structure specs ---"

                group spaceGroup -decor normal {
                    var space_group {
                        -label "Crystal space group number (space_group):"
                        -validate nonnegint
                    }

                    var origin_choice {
                        -label "Which choice of origin to use (origin_choice):"
                        -widget radiobox
                        -value  {1 2}
                        -textvalue {"first choice"  "second choice"}
                    }
                    
                    group for_monoclinc -name "For monoclinic lattice:" -decor normal {
                        var uniqueb {
                            -label "Set the axis b as unique (uniqueb):"
                            -textvalue {Yes No}
                            -value     {.true. .false.}
                            -widget    radiobox
                        }
                    }
                    
                    group for_rhombohedral -name "For rhombohedral lattice:" -decor normal {
                        var rhombohedral {
                            -label "Specify the coordinates with respect to rhombohedral axes (rhombohedral):"
                            -textvalue {Yes No}
                            -value     {.true. .false.}
                            -widget    radiobox
                        }
                    }
                }                   

                separator -label "--- Two chemical-potential calculation (twochem) options ---"
                
                group twochem_group -decor normal {
                    var nbnd_cond {
                        -label "Number of conduction states for \"twochem\" calculation (nbnd_cond):"
                        -validate int
                    }

                    var degauss_cond {
                        -label "\"Twochem\" gaussian spreading for conduction electrons (degauss_cond):"
                        -validate fortranreal
                    }

                    var nelec_cond {
                        -label "Number of conduction electrons for \"twochem\" calculation (nelec_cond):"
                        -validate fortranreal
                    }
                }

                separator -label "--- Charged plate (gate) options ---"
                
                group gate_group -decor normal {
                    var zgate {
                        -label "Z position of the charged plate (zgate):"
                        -validate fortranposreal
                    }

                    var relaxz {
                        -label "Allow the system to relax towards the charged plate (relaxz):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }

                    var block {
                        -label "Add a potential barrier to the total potential (block):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                    
                    var block_1 {
                        -label "Lower end of the potential barrier (block_1):"
                        -validate fortranposreal
                    }
                    
                    var block_2 {
                        -label "Upper end of the potential barrier (block_2):"
                        -validate fortranposreal
                    }
                    
                    var block_height {
                        -label "Height of the potential barrier \[in Ry\] (block_height):"
                        -validate fortranreal
                    }               
                }

                separator -label "--- gammaDFT options ---"
                
                group gammaDFT_group -decor normal {
                    var sic_gamma {
                        -label "Strength of the gammaDFT potential (sic_gamma):"
                        -validate fortranreal
                    }

                    var pol_type {
                        -label "Type of polaron in gammaDFT (pol_type):"
                        -widget radiobox
                        -textvalue {
                            "electron polaron"
                            "hole polaron"
                        }
                        -value {
                            'e'
                            'h'
                        }
                    }

                    var sic_energy {
                        -label "Calculate the total energy in gammaDFT (sic_energy):"
                        -widget    radiobox
                        -textvalue { Yes No }	      
                        -value     { .true. .false. }
                    }

                    var sci_vb {
                        -label "Valence band shift \[in eV\] for gammaDFT (sci_vb):"
                        -validate fortranreal
                    }

                    var sci_cb {
                        -label "Conduction band band shift \[in eV\] for gammaDFT (sci_cb):"
                        -validate fortranreal
                    }
                }

                separator -label "--- External ionic force fields ---"
                
                var nextffield {
                    -label "Number of activated external ionic force fields (nextffield):"
                    -validate int
                }
                
                separator -label "--- FFT meshes ---"

                group fft_mesh_group -decor normal {
                    group nrx {
                        separator -label "--- hard grid for charge density ---"
                        packwidgets left
                        var nr1 -label "nr1:" -validate posint -widget spinint
                        var nr2 -label "nr2:" -validate posint -widget spinint
                        var nr3 -label "nr3:" -validate posint -widget spinint
                    }

                    group nrxs {
                        separator -label "--- soft grid for wavefunction ---"
                        packwidgets left
                        var nr1s -label "nr1s:" -validate posint -widget spinint
                        var nr2s -label "nr2s:" -validate posint -widget spinint
                        var nr3s -label "nr3s:" -validate posint -widget spinint
                    }
                }
            }
        }
    }

    ########################################################################
    ##                                                                    ##
    ##                      &ELECTRONS NAMELIST                           ##
    ##                                                                    ##
    ########################################################################

    page electronsPage -name "Electrons" {
        namelist electrons -name "ELECTRONS" {
            optional {
                var electron_maxstep {
                    -label     "Max. \# of iterations in SCF step (electron_maxstep):"
                    -widget    spinint
                    -validate  posint
                    -fmt       %d
                }

                var exx_maxstep {
                    -label "Max. \# of outer iterations with exact exchange (exx_maxstep):"
                    -validate int
                }

                var scf_must_converge {
                    -label     "Stop MD or ionic relaxation if SCF fails to converge (scf_must_converge):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }
                }
                
                var conv_thr {
                    -label     "Convergence threshold for selfconsistency (conv_thr):"
                    -validate  fortranposreal
                }

                var startingpot {
                    -label    "Type of starting potential (startingpot):"
                    -widget   optionmenu
                    -textvalue {
                        "from atomic charge superposition  <atomic>"
                        {from existing potential "prefix".pot file  <file>}
                    }
                    -value {'atomic' 'file'}
                }

                var startingwfc {
                    -label    "Type of starting wavefunctions (startingwfc):"
                    -widget   optionmenu
                    -textvalue {
                        "from superposition of atomic orbitals  <atomic>"
                        "from <atomic> + superimposed \"randomization\"  <atomic+random>"
                        "from random wavefunctions  <random>"
                        "from existing wavefunction file  <file>"
                    }
                    -value {'atomic' 'atomic+random' 'random' 'file'}
                }

                separator -label "--- Adaptive convergence setup for EXX ---"
                
                group adaptive_thr_group -decor normal {
                    var adaptive_thr {
                        -label     "Use adaptive convergence threshold for EXX (adaptive_thr):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                    
                    group adaptive_thr_setup -decor none {
                        var conv_thr_init  {
                            -label     "Convergence threshold used for the first scf cycle (conv_thr_init):"
                            -validate  fortranposreal
                        }                   
                        var conv_thr_multi {
                            -label     "Convergence threshold factor for the rest of scf cycles (conv_thr_multi):"
                            -validate  fortranposreal
                        }
                    }
                }

                separator -label "--- SCF mixing ---"

                group scf_mixing -decor normal {

                    var mixing_mode {
                        -label     "Mixing mode (mixing_mode):"
                        -textvalue {
                            "charge density Broyden mixing  <plain>"
                            "charge density Broyden mixing with simple Thomas-Fermi (TF) screening  <TF>"
                            "charge density Broyden mixing with local-density-dependent TF screening  <local-TF>"
                        }
                        -value {
                            'plain' 
                            'TF'    
                            'local-TF'
                        }
                        -widget optionmenu
                    }
                    
                    var mixing_beta {
                        -label    "Mixing factor for self-consistency (mixing_beta):"
                        -validate  fortranposreal
                    }

                    var mixing_ndim {
                        -label    "Number of iterations used in mixing scheme (mixing_ndim):"
                        -widget   spinint
                        -validate posint
                        -fmt      %d
                    }

                    var mixing_fixed_ns {
                        -text     "For LDA+U only: ns = atomic density appearing in the Hubbard term"
                        -label    "Number of iterations with fixed ns (mixing_fixed_ns):" 
                        -widget   spinint
                        -validate posint
                        -fmt      %d
                    }
                }
                separator -label "--- Diagonalization ---"

                group diag_group -decor normal {
                    var diagonalization {
                        -label    "Type of diagonalization (diagonalization):"
                        -textvalue {
                            "Davidson with overlap matrix  <david>"
                            "Conjugate-gradient band-by-band <cg>"
                            "PPCG iterative diagonalization <ppcg>"
                            "ParO iterative diagonalization <paro>"
                            "RMM-DIIS iterative diagonalization <rmm-davidson>"
                        }
                        -value {
                            'david'
                            'cg'
                            'ppcg'
                            'paro'
                            'rmm-davidson'
                        }
                        -widget optionmenu
                    }
                    
                    var diago_thr_init {
                        -label "Convergence threshold for 1st iterative diagonalization (diago_thr_init):"
                        -validate fortranreal
                    }
                    
                    var diago_full_acc {
                        -label "Diagonalize empty states as precise as occupied states (diago_full_acc):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }

                    var diago_rmm_ndim {
                        -label "Subspace dimension for RMM-DIIS (diago_rmm_ndim):"
                        -validate int
                    }
                    
                    var diago_rmm_conv {
                        -label "Reiterate RMM-DIIS until all bands are converged (diago_rmm_conv):"
                        -widget    radiobox
                        -textvalue { Yes No }	      
                        -value     { .true. .false. }
                    }

                    var diago_gs_nblock {
                        -label "RMM-DIIS blocking size of Gram-Schmidt orthogonalization (diago_gs_nblock):"
                        -validate int
                    }

                    separator -label "--- Conjugate-Gradient diagonalization ---"
                    
                    var diago_cg_maxiter {
                        -label    "Max. \# of iterations for CG (diago_cg_maxiter):"
                        -widget   spinint
                        -validate posint
                        -fmt      %d
                    }

                    var diago_ppcg_maxiter {
                        -label    "Max. \# of iterations for PPCG (diago_ppcg_maxiter):"
                        -widget   spinint
                        -validate posint
                        -fmt      %d
                    }

                    separator -label "--- Davidson diagonalization ---"
                    
                    var diago_david_ndim {
                        -label    "Dimension of workspace (diago_david_ndim):"
                        -widget   spinint
                        -validate posint
                        -fmt      %d
                    }
                }

                separator -label "--- Finite electric field calculation ---"
                
                group elfield_group -decor normal {
                    var efield {
                        -label    "The intensity of the electric field (efield):"
                        -validate fortranreal
                    }
                    
                    dimension efield_cart {
                        -label    "Finite electric field in cartesian axis (efield_cart):"
                        -validate fortranreal
                        -start    1
                        -end      3
                    }

                    var efield_phase {
                        -label "Efield_phase (efield_phase):"
                        -widget optionmenu
                        -value { 'read' 'write' 'none' }
                    }
                }
                
                separator -label "--- Real space algorithms ---"
                
                var tqr {
                    -label "Use real-space algorithm for augmentation charges (tqr):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }               
                }

                var real_space {
                    -label "Exploit real-space localization (real_space):"
                    -widget    radiobox
                    -textvalue { Yes No }              
                    -value     { .true. .false. }
                }               
            }    
        }
    }

    ########################################################################
    ##                                                                    ##
    ##                      &IONS NAMELIST                                ##
    ##                                                                    ##
    ########################################################################

    page ionsPage -name "Ions" {        
        namelist ions -name "IONS" {
            optional {
                # this should be modified as it is CASE dependent               
                var ion_dynamics {
                    -label "Type of ionic dynamics (ion_dynamics):"
                    -widget   optionmenu
                    -textvalue {
                        "BFGS quasi-newton method for structural optimization  <bfgs>"
                        "damped dynamics (quick-min Verlet) for structural optimization  <damp>"
                        "FIRE minimization algorithm  <fire>"
                        "Verlet algorithm for molecular dynamics  <verlet>"
                        "over-damped Langevin dynamics  <langevin>"
                        "over-damped Langevin with Smart Monte Carlo  <langevin-smc>"
                        "Beeman algorithm for variable cell damped dynamics  <damp>"
                        "Beeman algorithm for variable cell MD  <beeman>"
                    }
                    -value {
                        'bfgs' 
                        'damp'
                        'fire'
                        'verlet'
                        'langevin'
                        'langevin-smc'
                        'damp'
                        'beeman'
                    }
                }

                var ion_positions {
                    -label "Which ion positions to use when restarting (ion_positions):"
                    -widget radiobox
                    -textvalue { 
                        "from restart file <default>"
                        "from standard input <from_input>"                   
                    }
                    -value { 'default' 'from_input' }
                }

                var ion_velocities {
                    -label "Initial ionic velocities (ion_velocities):"
                    -validate string
                    -widget radiobox
                    -textvalue { 
                        "random thermalized <default>"
                        "from standard input <from_input>"                   
                    }
                    -value { 'default' 'from_input' }
                }

                var pot_extrapolation {
                    -text "Extrapolation for the potential"
                    -label "Type of extrapolation (pot_extrapolation):"
                    -textvalue {
                        "no extrapolation  <none>"
                        "extrapolate the potential as a sum of atomic-like orbitals  <atomic>"
                        "extrapolate potential with first-order  formula  <first_order>"
                        "extrapolate potential with second-order formula  <second_order>"
                    }
                    -value {
                        'none' 'atomic' 'first_order' 'second_order'
                    }
                    -widget optionmenu
                }
                
                var wfc_extrapolation {
                    -text "Extrapolation for the wavefunctions"
                    -label "Type of extrapolation (wfc_extrapolation):"
                    -textvalue {
                        "no extrapolation  <none>"
                        "extrapolate wave-functions with first-order  formula  <first_order>"
                        "extrapolate wave-functions with second-order formula  <second_order>"
                    }
                    -value {
                        'none' 'first_order' 'second_order'
                    }
                    -widget optionmenu
                }                

                var remove_rigid_rot {
                    -label "Remove the total torque from internal forces (remove_rigid_rot):"
                    -widget    radiobox
                    -textvalue { Yes No }             
                    -value     { .true. .false. }               
                }

                separator -label "--- Molecular Dynamics ---"

                group md -decor normal {
                    var ion_temperature {
                        -label    "Controlling of ions temperature (ion_temperature):"
                        -widget   optionmenu
                        -textvalue {
                            "velocity rescaling via tempw&tolp  <rescaling>"
                            "velocity rescaling via tempw&nraise  <rescale-v>"
                            "velocity rescaling via delta_t  <rescale-T>"
                            "reduce ionic temperature via delta_t&nraise  <reduce-T>"
                            "\"soft\" Berendsen velocity rescaling via tempw&nraise  <berendsen>"
                            "use Andersen thermostat via tempw&nraise  <andersen>"
                            "stochastic-velocity rescaling  <srv>"
                            "initialize to temperature \"tempw\" and leave uncontrolled  <initial>"
                            "not controlled  <not_controlled>"
                        }
                        -value {
                            'rescaling'
                            'rescale-v'
                            'rescale-T'
                            'reduce-T'
                            'berendsen'
                            'andersen'
                            'srv'
                            'initial'
                            'not_controlled'
                        }
                    }
                    
                    var tempw {
                        -label    "Starting temperature in MD runs (tempw):"
                        -validate  fortrannonnegreal
                    }
                    
                    var tolp {
                        -label    "Tolerance for velocity rescaling (tolp):"
                        -validate fortranreal
                    }
                    
                    var delta_t {
                        -label    "Temperature rescaling (delta_t):"
                        -validate fortranreal
                    }
                    
                    var nraise {
                        -label    "Rescaling interval (nraise):"
                        -validate integer
                    }

                    var refold_pos {
                        -label "Refolded ions at each step into the supercell (refold_pos):"
                        -widget    radiobox
                        -textvalue { Yes No }         
                        -value     { .true. .false. }
                    }
                }

                separator -label "--- BFGS Structural Optimization ---"

                group bfgs -decor normal {
                    var upscale {
                        -label   "Maximum reduction factor for conv_thr during optimization (upscale):"
                        -validate  fortranposreal
                    }

                    var bfgs_ndim {
                        -label "Number of old forces and displacements used in the Pulay mixing (bfgs_ndim):"
                        -widget   spinint
                        -validate posint
                    }

                    var trust_radius_max {
                        -label "Maximum ionic displacement in the structural relaxation (trust_radius_max):"
                        -validate fortranposreal
                    }

                    var trust_radius_min {
                        -label "Minimum ionic displacement in the structural relaxation (trust_radius_min):"
                        -validate fortranposreal
                    }

                    var trust_radius_ini {
                        -label "Initial ionic displacement in the structural relaxation (trust_radius_ini):"
                        -validate fortranposreal
                    }
                    
                    group w1_w2 -name "Parameters used in line search based on the Wolfe conditions:" -decor normal {
                        packwidgets left
                        var w_1 -label "w_1:" -validate fortranreal                     
                        var w_2 -label "w_2:" -validate fortranreal                     
                    }
                }

                separator -label "--- FIRE Structural Optimization ---"

                group fire -decor normal {
                    var fire_alpha_init {
                        -label "Initial alpha mixing factor for FIRE (fire_alpha_init):"
                        -validate fortranreal
                    }

                    var fire_falpha {
                        -label "Scaling of the alpha mixing parameter (fire_falpha):"
                        -validate fortranreal
                    }
                    
                    var fire_nmin {
                        -label "Min number of steps with P > 0 before increasing dt (fire_nmin):"
                        -validate int
                    }
                    
                    var fire_f_inc {
                        -label "Factor for increasing dt (fire_f_inc):"
                        -validate fortranreal
                    }
                    
                    var fire_f_dec {
                        -label "Factor for decreasing dt (fire_f_dec):"
                        -validate fortranreal
                    }
                    
                    var fire_dtmax {
                        -label "Maximum scaling of dt during FIRE (fire_dtmax):"
                        -validate fortranreal
                    }
                }
            }
        }
    }


    ########################################################################
    ##                                                                    ##
    ##                      &CELL NAMELIST                                ##
    ##                                                                    ##
    ########################################################################

    page variableCellPage -name "Variable Cell" {

        namelist cell -name "CELL" {
            var cell_dynamics {
                -label "Type of dynamics for the cell (cell_dynamics):"
                -textvalue {
                    "None  <none>"
                    "Damped (Beeman) dynamics of the Parrinello-Raman extended lagrangian  <damp-pr>"
                    "Damped (Beeman) dynamics of the new Wentzcovitch extended lagrangian  <damp-w>"
                    "BFGS quasi-newton algorithm (ion_dynamics must be 'bfgs' too)  <bfgs>"
                    "(Beeman) dynamics of the Parrinello-Raman extended lagrangian  <pr>"
                    "(Beeman) dynamics of the new Wentzcovitch extended lagrangian  <w>"
                }           
                -value {
                    'none'
                    'damp-pr'
                    'damp-w'
                    'bfgs'
                    'pr'
                    'w'
                }
                -widget optionmenu
            }
            
            var press {
                -label    "Target pressure \[in KBar\] in a variable-cell MD (press):"
                -validate  fortranreal
            }
            
            var wmass {
                -label    "Ficticious cell mass for variable-cell MD (wmass):"
                -validate  fortranreal

            }
            
            var press_conv_thr {
                -label     "Convergence pressure threshold \[in KBar\] (press_conv_thr):"
                -validate  fortranposreal
            }
            
            var cell_factor {
                -text     "This variable is used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation"
                -label    "Cell factor (cell_factor):"
                -validate  fortranreal
            }

            var cell_dofree {
                -label "Which of the cell parameters should be moved (cell_dofree):"
                -value {
                    'all'
                    'ibrav'
                    'a'
                    'b'
                    'c'
                    'fixa'
                    'fixb'
                    'fixc'
                    'x'
                    'y'
                    'z' 
                    'xy' 
                    'xz' 
                    'yz' 
                    'xyz' 
                    'shape' 
                    'volume' 
                    '2Dxy' 
                    '2Dshape' 
                    'epitaxial_ab' 
                    'epitaxial_ac' 
                    'epitaxial_bc'
                }
                
                -textvalue {
                    {'all' =    all axis and angles are moved}
                    {'ibrav' =  all axis and angles are moved, but ibrav is kept}
                    {'a' =      the x component of axis 1 (v1_x) is fixed}
                    {'b' =      the y component of axis 2 (v2_y) is fixed}
                    {'c' =      the z component of axis 3 (v3_z) is fixed}
                    {'fixa' =   axis 1 (v1_x,v1_y,v1_z) is fixed}
                    {'fixb' =   axis 2 (v2_x,v2_y,v2_z) is fixed}
                    {'fixc' =   axis 3 (v3_x,v3_y,v3_z) is fixed}
                    {'x' =      only the x component of axis 1 (v1_x) is moved}
                    {'y' =      only the y component of axis 2 (v2_y) is moved}
                    {'z' =      only the z component of axis 3 (v3_z) is moved}
                    {'xy' =     only v1_x and v2_y are moved}
                    {'xz' =     only v1_x and v3_z are moved}
                    {'yz' =     only v2_y and v3_z are moved}
                    {'xyz' =    only v1_x, v2_y, v3_z are moved}
                    {'shape' =  all axis and angles, keeping the volume fixed}
                    {'volume' = the volume changes, keeping all angles fixed}
                    {'2Dxy'   = only x and y components are allowed to change}
                    {'2Dshape' = as above, keeping the area in xy plane fixed}
                    {'epitaxial_ab' = fix axis 1 and 2 while allowing axis 3 to move}
                    {'epitaxial_ac' = fix axis 1 and 3 while allowing axis 2 to move}
                    {'epitaxial_bc' = fix axis 2 and 3 while allowing axis 1 to move}
                }
                -widget optionmenu
            }
        }
    }


    ########################################################################
    ##                                                                    ##
    ##                      &FCP and &RISM NAMELISTS                      ##
    ##                                                                    ##
    ########################################################################

    page fcpPage -name "FCP & RISM" {

        namelist fcp -name "FCP" {
            var fcp_mu {
                -label "Target Fermi energy \[in Ry\] for constant bias \"lfcp\" calculation (fcp_mu):"
                -validate fortranreal
            }

            var fcp_dynamics {
                -label "Type of FCP dynamics for the FCP (fcp_dynamics):"
                -textvalue {
                    "BFGS quasi-newton algorithm  <bfgs>"
                    "Newton-Raphson algorithm with DIIS  <newton>"
                    "damped (quick-min Verlet) dynamics  <damp>"
                    "line-minimization algorithm  <lm>"
                    "Velocity-Verlet algorithm  <velocity-verlet>"
                    "Verlet algorithm  <verlet>"                
                }           
                -value {
                    'bfgs'     
                    'newton'   
                    'damp'     
                    'lm'       
                    'velocity-verlet'
                    'verlet'         
                }
                -widget optionmenu
            }

            var fcp_conv_thr {
                -label "Convergence threshold on force (in eV) for FCP relaxation (fcp_conv_thr):"
                -validate fortranreal
            }

            var fcp_ndiis {
                -label "Size of DIIS for FCP relaxation (fcp_ndiis):"
                -validate int
            }
            
            group for_fcp_dynamics -name "FCP dynamics specs:" -decor normal {
                var fcp_mass {
                    -label "Mass of the FCP (fcp_mass):"
                    -validate fortranreal
                }
                
                var fcp_velocity {
                    -label "Initial velocity of the FCP (fcp_velocity):"
                    -validate fortranreal
                }
                
                var fcp_temperature {
                    -label "Controlling of FCP temperature (fcp_temperature):"
                    -widget   optionmenu
                    -textvalue {
                        "velocity rescaling via fpc_tempw and fcp_tolp  <rescaling>"
                        "velocity rescaling via fcp_tempw and fcp_nraise  <rescale-v>"
                        "velocity rescaling via fcp_delta_t  <rescale-T>"
                        "reduce FCP's temperature via fcp_nraise and fcp_delta_t  <reduce-T>"
                        "\"soft\" Berendsen velocity rescaling via fcp_tempw and fcp_nraise  <berendsen>"
                        "use Andersen thermostat via fcp_tempw and fcp_nraise  <andersen>"
                        "initialize to temperature \"fcp_tempw\" and leave uncontrolled  <initial>"
                        "not controlled  <not_controlled>"
                    }
                    -value {
                        'rescaling'
                        'rescale-v'
                        'rescale-T'
                        'reduce-T'
                        'berendsen'
                        'andersen'
                        'initial'
                        'not_controlled'
                    }                
                }
                
                var fcp_tempw {
                    -label "Starting FCP temperature (fcp_tempw):"
                    -validate fortranreal
                }
                
                var fcp_tolp {
                    -label "Tolerance for FCP velocity rescaling (fcp_tolp):"
                    -validate fortranreal
                }
                
                var fcp_delta_t {
                    -label "FCP temperature rescaling (fcp_delta_t):"
                    -validate fortranreal
                }
                
                var fcp_nraise {
                    -label "FCP rescaling interval (fcp_nraise):"
                    -validate int
                }
            }
            
            var freeze_all_atoms {
                -label "Freeze all atoms in FCP dynamics (freeze_all_atoms):"
                -widget    radiobox
                -textvalue { Yes No }	      
                -value     { .true. .false. }
            }            
        }

        namelist rism -name "RISM" {
            var nsolv {
                -label "Number of solvents (nsolv):"
                -widget spinint
                -validate posint
            }            

            var closure {
                -label "Type of closure equation (closure):"
                -widget radiobox
                -textvalue {
                    "HyperNetted-Chain model <hcn>"
                    "Kovalenko and Hirata's model <kh>"
                }
                -value {
                    'hcn' 'kh'
                }
            }
            var tempv {
                -label "Solvent temperature in Kelvin (tempv):"
                -validate fortranposreal
            }
            var ecutsolv {
                -label "Energy cutoff for 3D-RISM in Rydberg (ecutsolv):"
                -validate fortranposreal
            }
            dimension solute_lj {
                -label "Type of Lennard-Jones force fields for solutes"
                -widget optionmenu
                -textvalue {
                    "None <none>"
                    "Universal Force Field <uff>"
                    "Clay's Force Field <clayff>"
                    "OPLS-AA (generic parameters for QM/MM) <opls-aa>"
                }
                -value {
                    'none'
                    'uff'
                    'clayff'
                    'opls-aa'
                }
                -start 1 -end 1
            }
            dimension solute_epsilon {
                -label "Lennard-Jones `epsilon' parameters for solutes \[in kcal/mol\]"
                -validate fortranreal
                -start 1 -end 1
            }
            dimension solute_sigma {
                -label "Lennard-Jones `sigma' parameters for solutes \[in Angstroms\]"
                -validate fortranreal
                -start 1 -end 1
            }
            page rism_1d -name "1D-RISM" {
                var starting1d {
                    -label "How to initialize the 1D-RISM's correlation function 
(starting1d):"      
                    -widget optionmenu
                    -textvalue {
                        "start from 0 <zero>"
                        "read from file <file>"
                        "read from file, and fix correlation function <fix>"
                    }
                    -value {
                        'zero'
                        'file'
                        'fix'
                    }
                }
                var smear1d {
                    -label "Smearing radius for 1D-RISM \[in Bohr\] (smear1d):"
                    -validate fortranposreal
                }
                var rism1d_maxstep {
                    -label "Maximum number of steps for 1D-RISM (rism1d_maxstep)"
                    -validate posint
                }
                var rism1d_conv_thr {
                    -label "Convergence threshold for 1D-RISM (rism1d_conv_thr):"
                    -validate fortranposreal
                }
                var mdiis1d_size {
                    -label "Size of MDIIS for 1D-RISM (mdiis1d_size):"
                    -validate posint
                }
                var mdiis1d_step {
                    -label "Step of MDIIS for 1D-RISM (mdiis1d_step):"
                    -validate fortranreal
                }
                var rism1d_bond_width {
                    -label "Gaussian width of bonds for 1D-RISM (rism1d_bond_width):"
                    -validate fortranposreal
                }
                var rism1d_dielectric {
                    -label "Dielectric constant for 1D-RISM (rism1d_dielectric):"
                    -validate fortranreal
                }
                var rism1d_molesize {
                    -label "Size of solvent molecule for 1D-RISM 
\[in Bohr\] (rism1d_molesize):"
                    -validate fortranposreal
                }
                var rism1d_nproc {
                    -label "Number of processes to calculate for 1D-RISM (rism1d_nproc):"
                    -validate nonnegint
                }
            }
            
            page rism_3d -name "3D-RISM" {
                var starting3d {
                    -label "How to initialize the 3D-RISM's correlation function 
(starting3d):"
                    -widget optionmenu
                    -textvalue {
                        "start from 0 <zero>"
                        "read from file <file>"
                    }
                    -value {
                        'zero'
                        'file'
                    }
                }
                var smear3d {
                    -label "Smearing radius for 3D-RISM \[in Bohr\] (smear1d):"
                    -validate fortranposreal
                }
                var rism3d_maxstep {
                    -label "Maximum number of steps for 3D-RISM (rism3d_maxstep)"
                    -validate posint
                }
                var rism3d_conv_thr {
                    -label "Convergence threshold for 3D-RISM (rism3d_conv_thr):"
                    -validate fortranposreal
                }
                var mdiis3d_size {
                    -label "Size of MDIIS for 3D-RISM (mdiis3d_size):"
                    -validate posint
                }
                var mdiis3d_step {
                    -label "Step of MDIIS for 3D-RISM (mdiis3d_step):"
                    -validate fortranreal
                }
                var rism3d_conv_level {
                    -label "Convergence level for 3D-RISM (rism3d_conv_level):"
                    -validate fortranreal
                }
                var rism3d_planar_average {
                    -label "Calculate planar average of solvents after 3D-RISM 
calculation (rism3d_planar_average):"
                    -widget radiobox
                    -textvalue { Yes No }
                    -value { .true. .false. }
                }   
            }

            page rism_laue -name "Laue-RISM" {
                var laue_both_hands {
                    -label "Use both-hands method in Laue-RISM (laue_both_hands):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }

                var laue_nfit {
                    -label "Number of fitting points in Laue-RISM (laue_nfit):"
                    -widget   spinint
                    -validate posint
                }
                var laue_expand_right {
                    -label "Expanding length on right-hand side in Laue-RISM 
\[in Bohr\] (laue_expand_right):"
                    -validate fortranreal
                }
                var laue_expand_left {
                    -label "Expanding length on left-hand side in Laue-RISM 
\[in Bohr\] (laue_expand_left):"
                    -validate fortranreal
                }
                
                var laue_starting_right {
                    -label "Starting position on right-hand side in Laue-RISM 
\[in Bohr\] (laue_starting_right):"
                    -validate fortranreal
                }
                var laue_starting_left {
                    -label "Starting position on left-hand side in Laue-RISM 
\[in Bohr\] (laue_starting_left):"
                    -validate fortranreal
                }
                
                var laue_buffer_right {
                    -label "Buffering length on right-hand side in Laue-RISM 
\[in Bohr\] (laue_buffer_right):"
                    -validate fortranreal
                }
                
                var laue_buffer_left {
                    -label "Buffering length on left-hand side in Laue-RISM 
\[in Bohr\] (laue_buffer_left):"
                    -validate fortranreal
                }

                var laue_wall {
                    -label "Repulsive wall with (1/r)^12 term of Lennard-Jones 
potential (laue_wall):"
                    -widget radiobox
                    -textvalue {
                        "wall is not defined <none>"
                        "edge position of wall is defined automatically <auto>"
                        "edge position of wall is defined manually <manual>"
                    }
                    -value {
                        'none'
                        'auto'
                        'manual'
                    }
                }

                var laue_wall_z {
                    -label "Edge position of repulsive wall in Laue-RISM 
\[in Bohr\] (laue_wall_z):"
                    -validate fortranreal
                }

                var laue_wall_rho {
                    -label "Density of repulsive wall in Laue-RISM 
\[in 1/Bohr^3\] (laue_wall_rho):"
                    -validate fortranreal
                }

                var laue_wall_epsilon {
                    -label "Lennard-Jones parameter `epsilon' for repulsive wall 
in Laue-RISM \[in kcal/mol\] (laue_wall_epsilon):"
                    -validate fortranreal
                }
                var laue_wall_sigma {
                    -label "Lennard-Jones parameters `sigma' for repulsive wall 
in Laue-RISM \[in Angstrom\] (laue_wall_sigma):"
                    -validate fortranreal
                }            
                var laue_wall_lj6 {
                    -label "Use attractive term of Lennard-Jones (laue_wall_lj6):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }            
            }
        }
    }

    ########################################################################
    ##                                                                    ##
    ##     CARDS: CELL_PARAMETERS, ATOMIC_SPECIES, ATOMIC_POSITIONS       ##
    ##                                                                    ##
    ########################################################################

    page latticeAtomdataPage -name "Lattice & Atoms" {

        #
        # CELL_PARAMETERS
        #
        group cards__CELL_PARAMETERS -name "Card: CELL_PARAMETERS" -decor normal {
            line lattice_type_line -decor none {
                keyword cell_parameters CELL_PARAMETERS
                var CELL_PARAMETERS_flags {
                    -label    "Cell parameter's unit:" 
                    -value    {alat bohr angstrom}
                    -textvalue {Alat Bohr Angstrom}
                    -widget   radiobox
                }
            }
            table lattice {
                -caption  "Lattice Basis Vectors:"
                -head     {X-Component Y-Component Z-Component}
                -validate {fortranreal fortranreal fortranreal}
                -cols     3
                -rows     3
                -outfmt   {"  %14.9f" %14.9f %14.9f}
            }   
        }

        #
        # ATOMIC_SPECIES
        #
        group atomic_species_group -name "Card: ATOMIC_SPECIES" -decor normal {
            keyword atomic_species_key ATOMIC_SPECIES\n
            table atomic_species \
                -caption  "Atomic types:" \
                -head     {Atomic-label Atomic-Mass Pseudopotential-file} \
                -cols     3 \
                -rows     1 \
                -outfmt   {"  %3s" %10.5f " %s"} \
                -validate {whatever fortranreal whatever} \
                -widgets  [list entry entry [list entrybutton "Pseudopotential ..." [list ::pwscf::pwSelectPseudopotential $this atomic_species]]]          
        }

        #
        # ATOMIC_POSITIONS
        #

        group atomic_positions_group -name "Card: ATOMIC_POSITIONS" -decor normal {
            line atom_coor_unit -decor none {
                keyword atomic_positions ATOMIC_POSITIONS
                var ATOMIC_POSITIONS_flags {
                    -label    "Atomic coordinate length unit:" 
                    -textvalue {
                        "Cartesian in ALAT (i.e. in length units of celldm(1))  <alat>"
                        "Cartesian in BOHR  <bohr>"
                        "Cartesian in ANGSTROMS  <angstroms>"
                        "Internal crystal coordinates  <crystal>"
                        "Internal crystal coordinates of inequivalent atoms <crystal_sg>"
                    }
                    -value {alat bohr angstrom crystal crystal_sg}          
                    -widget radiobox
                    -default "Cartesian in ALAT (i.e. in length units of celldm(1))  <alat>"
                }
            }
            
            table atomic_coordinates {
                -caption   "Atomic coordinates:"
                -head      {Atomic-label X-Coordinate Y-Coordinate Z-Coordinate if_pos(1) if_pos(2) if_pos(3)}
                -validate  {string fortranreal fortranreal fortranreal binary binary binary}
                -cols      7
                -rows      1
                -outfmt    {"  %3s" "  %14.9f" %14.9f %14.9f "  %2d" %2d %2d}
                -widgets   {entry entry entry entry checkbutton}
                -onvalues  1
                -offvalues 0
                -optionalcols 4
            }
            # -optcols   {4 5 6}

            loaddata atomic_coordinates ::pwscf::pwLoadAtomCoor \
                "Load atomic coordinates from file ..."    
        }
    }


    ########################################################################
    ##                                                                    ##
    ##                         CARD: K_POINTS                             ##
    ##                                                                    ##
    ########################################################################

    page kpointsPage -name "K-points" {
        #
        # K_POINTS
        #
        group k_points_group -name "Card: K_POINTS" -decor normal {
            line kpoint_type_line -decor none {
                keyword k_points K_POINTS
                var K_POINTS_flags {
                    -label    "K-points type:" 
                    -textvalue {
                        "Manual specification in 2pi/a units  <tpiba>"
                        "Manual specification in CRYSTAL units  <crystal>"
                        "Automatic generation  <automatic>"
                        "Gamma point only  <gamma>"
                        "Manual \"2pi/a\" specification for band structure plot <tpiba_b>"
                        "Manual \"crystal\" specification for band structure plot <crystal_b>"
                        "Manual \"2pi/a\" specification for band structure contour plot <tpiba_c>"
                        "Manual \"crystal\" specification for band structure contour plot <crystal_c>"
                    }
                    -value {
                        tpiba crystal automatic gamma tpiba_b crystal_b tpiba_c crystal_c
                    }
                    -widget radiobox
                    -default "Manual specification in 2pi/a units  <tpiba>"
                }
            }
            
            line nks_line -decor none {
                var nks -label "Number of K-points:" -widget spinint -validate posint -default 1
            }

            # if nks=0 then enter the mesh and shifts
            group kmesh_shift_group -name "k-points mesh + shift" -decor normal {
                line kmesh_line -decor none {
                    group kmesh -name Kmesh {
                        packwidgets left
                        var nk1 -label "nk1:"  -widget spinint  -validate posint  -outfmt "  %d "  -default 1
                        var nk2 -label "nk2:"  -widget spinint  -validate posint  -outfmt "%d "  -default 1
                        var nk3 -label "nk3:"  -widget spinint  -validate posint  -outfmt "%d "  -default 1
                    }
                    group kshift -name Kshift {
                        packwidgets left
                        var sk1 -label "sk1:"  -widget spinint  -validate binary  -outfmt "  %d "  -default 1
                        var sk2 -label "sk2:"  -widget spinint  -validate binary  -outfmt "%d "  -default 1
                        var sk3 -label "sk3:"  -widget spinint  -validate binary  -outfmt "%d "  -default 1
                    }
                }
            }

            # elseif nks>0 enetr kpoint coordinates
            table kpoints {
                -caption  "Enter the coordinates of the K-points below:"
                -head     {KX-Coordinate KY-Coordinate KZ-Coordinate Weight}
                -cols     4
                -rows     0
                -validate {fortranreal fortranreal fortranreal fortranreal}
                -outfmt   {%14.9f %14.9f %14.9f "  %14.9f"}
            }
            loaddata kpoints ::pwscf::pwLoadKPoints \
                "Load K-point coordinates from file ..."        
        }
        
        #
        # ADDITIONAL_K_POINTS
        #
        group add_k_points_group -name "Card: ADDITIONAL_K_POINTS" -decor normal {

            auxilvar specify_add_kpoints {
                -label     "Specify ADDITIONAL_K_POINTS:"
                -widget    radiobox
                -textvalue { Yes No }         
                -value     { .true. .false. }
            }

            group add_kpoints_specs -decor none {
                line add_kpoint_type_line -decor none {
                    keyword add_k_points ADDITIONAL_K_POINTS
                    var ADDITIONAL_K_POINTS_flags {
                        -label    "K-points type:" 
                        -textvalue {
                            "Manual specification in 2pi/a units  <tpiba>"
                            "Manual specification in CRYSTAL units  <crystal>"
                            "Manual \"2pi/a\" specification for band structure plot <tpiba_b>"
                            "Manual \"crystal\" specification for band structure plot <crystal_b>"
                            "Manual \"2pi/a\" specification for band structure contour plot <tpiba_c>"
                            "Manual \"crystal\" specification for band structure contour plot <crystal_c>"
                        }
                        -value {
                            tpiba crystal tpiba_b crystal_b tpiba_c crystal_c
                        }
                        -widget radiobox
                        -default "Manual specification in 2pi/a units  <tpiba>"
                    }
                }
            
                line add_nks_line -decor none {
                    var nks_add -label "Number of K-points:" -widget spinint -validate posint -default 1
                }
            
                # elseif nks>0 enetr kpoint coordinates
                table add_kpoints {
                    -caption  "Enter the coordinates of the additional K-points below:"
                    -head     {KX-Coordinate KY-Coordinate KZ-Coordinate Weight}
                    -cols     4
                    -rows     1
                    -validate {fortranreal fortranreal fortranreal fortranreal}
                    -outfmt   {%14.9f %14.9f %14.9f "  %14.9f"}
                }
                loaddata add_kpoints ::pwscf::pwLoadAddKPoints \
                    "Load additional K-point coordinates from file ..."        
            }
        }
    }

    ########################################################################
    ##                                                                    ##
    ##         PAGE: CONSTRAINTS, OCCUPATIONS, ATOMIC_VELOCITIES/FORCES   ##
    ##                                                                    ##
    ########################################################################
    page otherPage -name "Other Cards" {

        # CARD: HUBBARD
        page hubbard_page -name "Hubbard" {
            group hubbard_card -name "Card: HUBBARD" -decor normal {
                auxilvar hubbard_enable {
                    -label     "Activate the HUBBARD card:"
                    -value     {Yes No}
                    -widget    radiobox
                    -default   No
                }
                group hubbard_group -decor none {                
                    line hubbard_line -decor none {
                        keyword hubbard HUBBARD
                        var HUBBARD_flags {
                            -label "HUBBARD's card option:"
                            -value {
                                atomic
                                ortho-atomic
                                norm-atomic
                                wf
                                pseudo
                            }                    
                            -widget optionmenu
                        }
                    }
                    text hubbard_specs \
                        -label "Specs of the HUBBARD card:" \
                        -readvar ::pwscf::pwscf($this,HUBBARD)                
                }
            }
        }


        # CARD: CONSTRAINTS
        page constraints_page -name "Constraints" {
            group constraints_group -name "Card: CONSTRAINTS" -decor normal {
                
                auxilvar constraints_enable {
                    -label     "Use constraints:"
                    -value     {Yes No}
                    -widget    radiobox
                    -default   No
                }
                
                group constraints_card -decor none {
                    
                    keyword constraints_key CONSTRAINTS\n
                    
                    line constraints_line1 -decor none {
                        var nconstr {
                            -label    "Number of constraints:"                  
                            -validate posint
                            -widget   spinint
                            -default  1
                            -outfmt   "  %d "
                        }
                        var constr_tol {
                            -label    "Tolerance for keeping the constraints satisfied:"
                            -validate fortranposreal
                        }
                    }
                    
                    table constraints_table {
                        -caption  "Enter constraints data:\n    constraint-type   constr(1,.)   constr(2,.)   ...   { constr_target(.) }\n\n(see Help for the format of \"constraint-specification\")"
                        -head     {constraint-type constraint-specifications ... ... ... ...}
                        -validate {string fortranreal}
                        -cols     6
                        -rows     1
                        -optionalcols 3
                        -widgets  {{optionmenu {'type_coord' 'atom_coord' 'distance' 'planar_angle' 'torsional_angle' 'bennett_proj' 'potential_wall'}} entry}
                        -outfmt   {"  %s  " %S}
                        -infmt    {%d %S}
                    }
                }
            }
        }
        
        # CARD: OCCUPATIONS
        page occupations_page -name "Occupations" {
            group occupations_card -name "Card: OCCUPATIONS" -decor normal {            
                keyword occupations_key OCCUPATIONS\n
                text occupations_table \
                    -caption "Syntax for NON-spin polarized case:\n     u(1)  ....   ....   ....  u(10)\n     u(11) .... u(nbnd)\n\nSyntax for spin-polarized case:\n     u(1)  ....   ....   ....  u(10)\n     u(11) .... u(nbnd)\n     d(1)   ....  ....   ....  d(10)\n     d(11) .... d(nbnd)" \
                    -label   "Specify occupation of each state (from 1 to nbnd) such that 10 occupations are written per line:" \
                    -readvar ::pwscf::pwscf($this,OCCUPATIONS)
            }
        }

        page atm_vel_forces_page -name "Atomic Velocities + Forces" {
            
            # CARD: ATOMIC_VELOCITIES

            group atomic_velocities_group -name "Card: ATOMIC_VELOCITIES" -decor normal {

                keyword atomic_velocities_key ATOMIC_VELOCITIES\n
                
                table atomic_velocities {
                    -caption   "Atomic velocities:"
                    -head      {Atomic-label Vx-component Vy-component Vz-component}
                    -validate  {string fortranreal fortranreal fortranreal}
                    -cols      4
                    -rows      1
                    -outfmt    {"  %3s" "  %14.9f" %14.9f %14.9f}
                    -widgets   {entry entry entry entry}
                }
                
                loaddata atomic_velocities ::pwscf::pwLoadAtomicVelocities \
                    "Load atomic velocities from file ..."    
            }        
        
            # CARD: ATOMIC_FORCES

            group atomic_forces_group -name "Card: ATOMIC_FORCES" -decor normal {

                auxilvar specify_atomic_forces {
                    -label     "Specify atomic forces:"
                    -widget    radiobox
                    -textvalue { Yes No }         
                    -value     { .true. .false. }
                }
                
                group atomic_forces_specs -decor none {
                    keyword atomic_forces_key ATOMIC_FORCES\n
                    
                    table atomic_forces {
                        -caption   "Atomic forces:"
                        -head      {Atomic-label Fx-component Fy-component Fz-component}
                        -validate  {string fortranreal fortranreal fortranreal}
                        -cols      4
                        -rows      1
                        -outfmt    {"  %3s" "  %14.9f" %14.9f %14.9f}
                        -widgets   {entry entry entry entry}
                    }
                    
                    loaddata atomic_forces ::pwscf::pwLoadAtomicForces \
                        "Load atomic forces from file ..."    
                }
            }
        }

        page solvents_page -name "Solvents" {
            group solvents_card -name "Card: SOLVENTS" -decor normal {
                line solvents_line -decor none {
                    keyword solvents SOLVENTS
                    var SOLVENTS_flags {
                        -label    "Solvents' densities are specified as:"
                        -widget   radiobox
                        -textvalue {
                            "number of molecules per unit cell <1/cell>"
                            "molar concentrations <mol/L>"
                            "in gram per cm^3 <g/cm^3>"
                        }
                        -value {
                            1/cell
                            mol/L
                            g/cm^3
                        }
                    }
                }
                table laue_one_hand_table \
                    -caption "Specs of solvents (for laue_both_hands = .false.): " \
                    -head {{Solvent molecule's label} {its density} {its MOL file}} \
                    -cols 3 \
                    -rows 1 \
                    -outfmt {"  %S" %14.9f "  %S"} \
                    -validate {whatever fortranreal whatever} \
                    -widgets  [list entry entry [list entrybutton "MOL file ..." [list ::pwscf::pwSelectMOLfile $this laue_one_hand_table]]]
                
                table laue_both_hands_table \
                    -caption "Specs of solvents (for laue_both_hands = .true.): " \
                    -head {{Solvent molecule's label} {its left density} {its right density} {its MOL file}} \
                    -cols 4 \
                    -rows 1 \
                    -outfmt {"  %S" %14.9f %14.9f "  %S"} \
                    -validate {whatever fortranreal fortranreal whatever} \
                    -widgets  [list entry entry entry [list entrybutton "MOL file ..." [list ::pwscf::pwSelectMOLfile $this laue_both_hands_table]]]                
            }
        }
    }
    

    # ----------------------------------------------------------------------
    # take care of specialities
    # ----------------------------------------------------------------------
    source pw-event.tcl

    # ------------------------------------------------------------------------
    # source the HELP file
    # ------------------------------------------------------------------------
    source pw-help.tcl
}
