////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008 The Regents of the University of California
//
// This file is part of Qbox
//
// Qbox is distributed under the terms of the GNU General Public License
// as published by the Free Software Foundation, either version 2 of
// the License, or (at your option) any later version.
// See the file COPYING in the root directory of this distribution
// or <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
// ThWidth.h
//
////////////////////////////////////////////////////////////////////////////////

#ifndef THWIDTH_H
#define THWIDTH_H

#include<iostream>
#include<iomanip>
#include<sstream>
#include<cstdlib>
#include<stdexcept>

#include "Sample.h"

class ThWidth : public Var
{
  Sample *s;

  public:

  const char *name ( void ) const { return "th_width"; };

  int set ( int argc, char **argv )
  {
    if ( argc != 2 )
      throw invalid_argument("th_width takes one value");

    double v = atof(argv[1]);
    if ( v <= 0.0 )
      throw invalid_argument("th_width must be positive");

    s->ctrl.th_width = v;
    return 0;
  }

  string print (void) const
  {
     ostringstream st;
     st.setf(ios::left,ios::adjustfield);
     st << setw(10) << name() << " = ";
     st.setf(ios::right,ios::adjustfield);
     st << setw(10) << s->ctrl.th_width;
     return st.str();
  }

  ThWidth(Sample *sample) : s(sample) { s->ctrl.th_width = 100.0; }
};
#endif
